/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.roles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionTalents;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.constants.EnumCompanionStage;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;

public class GuiNpcCompanion
extends GuiNPCInterface2
implements ITextfieldListener,
ISliderListener {
    private final List<GuiNpcCompanionTalents.GuiTalent> talents = new ArrayList<GuiNpcCompanionTalents.GuiTalent>();
    private final RoleCompanion role;

    public GuiNpcCompanion(EntityNPCInterface npc) {
        super(npc);
        this.role = (RoleCompanion)npc.advanced.roleInterface;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.role.matureTo(EnumCompanionStage.values()[button.getValue()]);
                if (this.role.canAge) {
                    this.role.ticksActive = this.role.stage.matureAge;
                }
                this.func_73866_w_();
                break;
            }
            case 1: {
                Client.sendData(EnumPacketServer.RoleCompanionUpdate, this.role.stage.ordinal());
                break;
            }
            case 2: {
                this.role.canAge = button.getValue() == 1;
                this.func_73866_w_();
            }
        }
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        super.func_73863_a(i, j, f);
        for (GuiNpcCompanionTalents.GuiTalent talent : new ArrayList<GuiNpcCompanionTalents.GuiTalent>(this.talents)) {
            talent.func_73863_a(i, j, f);
        }
    }

    @Override
    public void elementClicked() {
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int y = this.guiTop + 4;
        this.addButton(new GuiNpcButton(0, this.guiLeft + 70, y, 90, 20, new String[]{EnumCompanionStage.BABY.name, EnumCompanionStage.CHILD.name, EnumCompanionStage.TEEN.name, EnumCompanionStage.ADULT.name, EnumCompanionStage.FULL_GROWN.name}, this.role.stage.ordinal()));
        this.addLabel(new GuiNpcLabel(0, "companion.stage", this.guiLeft + 4, y + 5));
        this.addButton(new GuiNpcButton(1, this.guiLeft + 162, y, 90, 20, "gui.update"));
        this.addButton(new GuiNpcButton(2, this.guiLeft + 70, y += 22, 90, 20, new String[]{"gui.no", "gui.yes"}, this.role.canAge ? 1 : 0));
        this.addLabel(new GuiNpcLabel(2, "companion.age", this.guiLeft + 4, y + 5));
        if (this.role.canAge) {
            GuiNpcTextField textField = new GuiNpcTextField(2, this, this.guiLeft + 162, y, 140, 20, this.role.ticksActive + "");
            textField.setMinMaxDefault(0L, Integer.MAX_VALUE, 0L);
            this.addTextField(textField);
        }
        EnumCompanionTalent inventory = EnumCompanionTalent.INVENTORY;
        this.talents.clear();
        this.talents.add(new GuiNpcCompanionTalents.GuiTalent(this.role, inventory, this.guiLeft + 4, y += 26));
        this.addSlider(new GuiNpcSlider(this, 10, this.guiLeft + 30, y + 2, 100, 20, (float)this.role.getExp(EnumCompanionTalent.INVENTORY) / 5000.0f));
        EnumCompanionTalent armor = EnumCompanionTalent.ARMOR;
        this.talents.add(new GuiNpcCompanionTalents.GuiTalent(this.role, armor, this.guiLeft + 4, y += 26));
        this.addSlider(new GuiNpcSlider(this, 11, this.guiLeft + 30, y + 2, 100, 20, (float)this.role.getExp(EnumCompanionTalent.ARMOR) / 5000.0f));
        EnumCompanionTalent sword = EnumCompanionTalent.SWORD;
        this.talents.add(new GuiNpcCompanionTalents.GuiTalent(this.role, sword, this.guiLeft + 4, y += 26));
        this.addSlider(new GuiNpcSlider(this, 12, this.guiLeft + 30, y + 2, 100, 20, (float)this.role.getExp(EnumCompanionTalent.SWORD) / 5000.0f));
        for (GuiNpcCompanionTalents.GuiTalent gui : this.talents) {
            gui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (i == 1) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
        }
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
        if (slider.getSliderValue() <= 0.0f) {
            slider.setString("gui.disabled");
            this.role.talents.remove((Object)EnumCompanionTalent.values()[slider.getID() - 10]);
        } else {
            slider.setDisplayString((int)Math.floor(slider.getSliderValue() * 5000.0f) + "/5000 exp");
            this.role.setExp(EnumCompanionTalent.values()[slider.getID() - 10], (int)(slider.getSliderValue() * 5000.0f));
        }
    }

    @Override
    public void mousePressed(IGuiNpcSlider slider) {
    }

    @Override
    public void mouseReleased(IGuiNpcSlider slider) {
    }

    @Override
    public void save() {
        Client.sendData(EnumPacketServer.RoleSave, this.role.save(new NBTTagCompound()));
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        if (textfield.getID() == 2) {
            this.role.ticksActive = textfield.getInteger();
        }
    }
}

